USE [NWIC_PanelMgmt]
GO

--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jerry Kohler
--Object/SP Name        : NVCC_AccessLog
--Server                : DNS   DNS.URL        
--Data Base             : NWIC_PanelMgmt
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 04-04-2016
--
--Last Changed          : 03-28-2017
--Last Changed By		: Brian Diggs
--Reason For Change		: Rolled ALTER TABLE statement into the CREATE TABLE.
--                        Added indexes based on recommendations of Jerry Kohler derived
--                        from suggestions from CDW (Andrew Kelly)
--                        Reformatted whitespace
--
--Last Changed          : 04-05-2016
--Last Changed By		: Brian Diggs
--Reason For Change		: Make AccessLogID autopopulate/increment
--
--Purpose               : To log usage of the NVCC (SITCoM) application.
--==================================================================================

IF (SELECT OBJECT_ID('App.NVCC_AccessLog')) IS NOT NULL
DROP TABLE App.NVCC_AccessLog

CREATE TABLE App.NVCC_AccessLog (
	AccessLogID        int not null identity(1,1) primary key,
	HostName           varchar(80),
	UserID             varchar(50),
	AccessDateTime     dateTime,
	[Action]           varchar(255),
	PatientSID         int,
	ElapsedTime        float NULL,
	DatabaseServerName varchar(50)
) ON [DefFG] WITH (DATA_COMPRESSION = PAGE)

CREATE INDEX NVCC_AccessLog_HostName_UserID
ON APP.NVCC_AccessLog(HostName, UserID) INCLUDE(AccessDateTime)
WITH(SORT_IN_TEMPDB=ON, DATA_COMPRESSION=PAGE)

CREATE INDEX NVCC_AccessLog_HostName_UserID_Action
ON APP.NVCC_AccessLog(HostName, UserID, Action)
WITH(SORT_IN_TEMPDB=ON, DATA_COMPRESSION=PAGE)
